// Open side panel on action click
chrome.sidePanel
    .setPanelBehavior({ openPanelOnActionClick: true })
    .catch((error) => console.error(error));

// Listener for messages from sidepanel or content scripts if needed
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.type === "GET_URL") {
        chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
            sendResponse({ url: tabs[0]?.url });
        });
        return true;
    }
});
